<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">
<#include "/macros/linkbutton.ftl">

  <@tableHeader Heading="Copy Source Connector" />

  <#if show_form?? >

    Please enter a name for the copy below and press "copy".
    
    <br /><br />
    <form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="copysourceconnector">
      <input type="hidden" name="connectorname" value="${connectorname}">
      
      <table cellspacing="0" cellpadding="0" border="0">

      <tr>
        <td class="pad1">Source Connector Name:</td>
        <td class="pad1">
      	  <input type="text" class="inwhite" maxlength="30" id="target" name="target" <#if connectorname??>value="copy_of_${connectorname}"</#if> help="<@appID/>:sourceconnector_copytarget">
        </td>
      </tr>
      
      <tr>
        <td style="padding-top: 30px;" class="pad1" colspan="4" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listsourceconnectors" helpid="sourceconnector_cancel" />
          <@formsubmit value="Copy" helpid="sourceconnector_copy" />          
        </td>
      </tr>
      </table>
    </form>

  <#elseif show_overwrite_request?? > 
  
    Another source connector with the requested name already exists. Overwrite the other source connector? 
    
    <br /><br />
	<form action="pt.do" method="post" onsubmit="this.submit();">
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="copysourceconnector">
      <input type="hidden" name="connectorname" value="${connectorname}">
      <input type="hidden" name="target" value="${target}">
      <input type="hidden" name="overwrite" value="1">

      <table cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td class="pad1" colspan="4" align="right">
          <@linkbutton value="Cancel" targeturl="pt.do?action=listsourceconnectors" helpid="sourceconnector_cancel" />
          <@formsubmit value="Copy" helpid="sourceconnector_confirmcopy" />          
        </td>
      </tr>
      </table>
      
    </form>
    
  <#elseif show_confirmation?? >
    
    Source Connector copied. The new source connector has been automatically disabled to allow modifications prior to importing files.<br /> 
    Please wait while the source connectors are re-read for the changes to take effect.<br /><br />
    
    <#assign timeout="8" />
	<#assign postprogresslocation="action=sourcemanagersettings">
    <#include "/sub/progressbar.ftl">
    
  <#elseif show_error?? >
  
    The source connector could not be copied, please see the server logs for details.
    
  </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">