<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

<#setting url_escaping_charset="UTF-8">

  <@tableHeader Heading="Source Connectors" />
  
  <#assign entries_per_page = 10 />
  <#assign entrylist = connectors /> 
  <#assign entry_prefix = "connector" />
  <#include "/sub/pagination_js.ftl">
  
  <table cellspacing="0" cellpadding="0" style="border:0px; width: 500px;">
  
   <tr>
	<td class="pad1" colspan="2">
	 Source connectors define directories used as input sources for images. Every source connector has a name which is 
	 represented by the first part of the image path used to address the contents of an source connector. <br />   
	 Note: Source Connectors might have been disabled automatically due
	 to configuration errors or non-existant import directories. Deactivated source connectors may not appear in the FSI Server 
	 webinterface.
	</td>
   </tr> 
   <tr> 
    <td class="sectionheader"></td>
    <td class="sectionheader" style="font-weight: bold; text-align:right">Page <span id="pagenumber">1</span> of ${last_page}</td>
   </tr>
   <tr>
    <td colspan="2"><hr size="1" class="hr1"/></td>
   </tr>
   <tr>
     <td class="pad1" colspan="2">
	  <#assign i = 0>
	  <#list connectors?keys?sort as connectorname>
	    <#assign i = i + 1>
	    <div id="connector${i}" style="clear: both; <#if (i > entries_per_page)>display: none;</#if>">
	      <div style="width: 380px; height: 26px; float: left;">
	        <span style="line-height: 26px">${connectorname}
	          <#if !connectors[connectorname]['enabled'] > <span style="font-size: 8pt; color: lightgrey">(disabled)</span></#if>
	          <#if connectors[connectorname]['enabled'] && connectors[connectorname]['images']?? && connectors[connectorname]['images'] != -1> <span style="font-size: 8pt; color: green;">(${connectors[connectorname]['images']} assets)</span></#if>
	        </span>
	      </div>
	      
	      <div style="width: 110px; height: 26px; float: left; text-align: right;">
	       <a href="pt.do?<@printRequiredParams method="get" />action=sourceconnectoraccess&connectorname=${connectorname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Edit Source Connector Access" alt="Edit Source Connector Access" src="images/apps/app22/edit_profile_access.png" id="app1iconic" <#if i==1>help="<@appID />:sourcemanagersettings_edit_connector_access"</#if> /></a>
	       <a href="pt.do?<@printRequiredParams method="get" />action=editsourceconnector&connectorname=${connectorname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Edit Source Connector" alt="Edit Source Connector" src="images/apps/app22/edit_profile.png" id="app1iconic" <#if i==1>help="<@appID />:sourcemanagersettings_edit_connector"</#if> /></a>
	       <a href="pt.do?<@printRequiredParams method="get" />action=copysourceconnector&connectorname=${connectorname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Copy Source Connector" alt="Copy Source Connector" src="images/apps/app22/copy_profile.png" id="app1iconic" <#if i==1>help="<@appID />:sourcemanagersettings_copy_connector"</#if> /></a>
	       <a href="pt.do?<@printRequiredParams method="get" />action=deletesourceconnector&connectorname=${connectorname?url}"><img onmouseout="spanup(this);" onmouseup="spanup(this);" onmousedown="spandown(this);" onmouseover="spanhover(this);" class="btnwhite" title="Delete Source Connector" alt="Delete Source Connector" src="images/apps/app22/delete_profile.png" id="app1iconic" <#if i==1>help="<@appID />:sourcemanagersettings_delete_connector"</#if> /></a>	       
          </div>
        </div>
	  </#list>
	  <#-- fill last page with empty rows -->
	  <#list (i+1)..total_rows as row>
	      <div id="connector${row}" style="clear: both; <#if (i > entries_per_page)>display: none;</#if>">
	       <div style="width: 380px; height: 26px; float: left;"><span style="line-height: 26px">&nbsp;</span></div>
	       <div style="width: 110px; height: 26px; float: left;"><span style="line-height: 26px">&nbsp;</span></div>
	      </div>
	  </#list>
	 </td>
   </tr>
   <tr>
      <td class="pad1" style="text-align: center; padding-bottom: 5px;" colspan="3">
       <#include "/sub/pagination_buttons.ftl">
      </td>
   </tr>
   <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>   
   <tr>
	 <td class="pad1" colspan="2" align="right">
		  <form action="pt.do" method="post" onsubmit="this.submit();">
          <@printRequiredParams method="post" />
          <input type="hidden" name="action" value="addsourceconnector">
          <@formsubmit value="Add Source Connector" helpid="sourcemanagersettings_add_sourceconnector" />
          </form>
	 </td>
   </tr>
  </table>
  <#include "/sub/pagination_init.ftl">
  <@tableFooter/>
	
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">