<#include "/framework/html_head.ftl">
<#include "/framework/top_menu.ftl">
<#include "/macros/formcheckbox.ftl">
<#include "/macros/formsubmit.ftl">

<#include "/macros/formtable.ftl">

  <@tableHeader Heading="FSI Viewer Settings" />

   <#if show_chooser??>
   
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="pad1" colspan="2">
        These pages allow managing installed FSI Viewer instances. The default instance 
        can be copied to a users directory and skins can be installed and removed from any instance. Start by choosing
        the FSI Viewer instance to manage.  
       </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="2">Default FSI Viewer</td>
      </tr>
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1" valign="top">
        Edit the settings for the default viewer, that apply to all users that do not have an own viewer. 
       </td>
       <td class="pad1" align="right" valign="bottom">
        <form action="pt.do" method="post" onsubmit="this.submit();">    
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="viewersettings">
         <input type="hidden" name="default" value="true">
         <@formsubmit value="Edit default FSI Viewer" helpid="viewer_edit_default" />
   	    </form>
       </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="2">Existing User FSI Viewers</td>
      </tr>
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1" valign="top">
        Select an existing User FSI Viewer to modify it.
       </td>
       <td class="pad1" align="right" valign="bottom" style="min-width: 200px">
        <form action="pt.do" method="post" onsubmit="this.submit();">    
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="viewersettings">
         <@formgfxselect objid="user" itemlist=existing_userviewers preselect=existing_userviewers?first.value helpid="" /><br />
   	     <@formsubmit value="Edit User FSI Viewer" helpid="viewer_edit_user" />
   	     </form>
       </td>
      </tr>
      <tr>
       <td class="sectionheader" colspan="2">Create a new User FSI Viewer</td>
      </tr>
      <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
      <tr>
       <td class="pad1" valign="top">
        Choose a name for the new viewer:
       </td>
       <td class="pad1" align="right" valign="bottom" style="min-width: 200px">
        <form action="pt.do" method="post" onsubmit="this.submit();">    
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="viewersettings">
         <input type="text" class="inwhite" name="user" /><br /><br />
   	     <@formsubmit value="Create User FSI Viewer" helpid="create_user_viewer" />
   	     </form>
       </td>
      </tr>
     </table>
   
   
   <#elseif show_created_confirmation?? >
   
      <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="pad1">
         <div style="width: 100%; text-align: center; color: green">Created User FSI Viewer.</div>
       </td>
      </tr>
      <td class="pad1" align="right" valign="bottom" style="min-width: 200px">
        <form action="pt.do" method="post" onsubmit="this.submit();">    
         <@printRequiredParams method="post" />
         <input type="hidden" name="action" value="addpublishingset" />
         <input type="hidden" name="viewerPath" value="${viewerPath}" />
   	     <@formsubmit value="Create Publishing Set using this Viewer" helpid="addpublishingset" />
   	     </form>
       </td>
      </table>
      
      
   <#elseif show_status??>
   
     <table cellspacing="0" cellpadding="0" style="border: 0px; width: 500px;">
      <tr>
       <td class="pad1" colspan="2">
         <#if message??><div style="width: 100%; text-align: center; color: green">${message}</div></#if>
       </td>
      </tr>
      
     <#if user??>

      <#if own_viewer?? && own_viewer >
         <#-- show options for this users FSI Viewer -->
         <tr>
          <td class="pad1" colspan="2">
            The following pages allow managing the selected users FSI Viewer instance. Skins for this user can be 
            uploaded or deleted, the complete viewer directory can be downloaded as a zip for backup purposes. The 
            personalized FSI Viewer instance can also be removed, in that case the selected user will use the default 
            viewer for future publications. 
          </td>         
         </tr>
         
     	 <tr>
     	   <td class="sectionheader" colspan="2">Manage Skins</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Upload and delete skins for this FSI Viewer. 
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
   	 	   <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="listskins">
            <input type="hidden" name="viewer" value="user">
            <input type="hidden" name="user" value="${user}">
   	        <@formsubmit value="Manage Skins" helpid="viewer_manage_skins" />
   	       </form>
          </td>  
     	 </tr>
     	 
     	 
     	 <tr>
     	   <td class="sectionheader" colspan="2">Update Viewer</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Upload and install an update for this FSI Viewer. 
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
   	 	   <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="updateviewers">
            <input type="hidden" name="preselect_viewer" value="${user}">
   	        <@formsubmit value="Update Viewer" helpid="viewer_update" />
   	       </form>
          </td>  
     	 </tr>
     	 
     	 
     	 <tr>
     	   <td class="sectionheader" colspan="2">ZIP and download FSI Viewer</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Create and download a zip file containing the users viewer.  
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
   	 	   <form action="pt.do" method="post" id="dlform">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="zipviewerdir">
            <input type="hidden" name="viewer" value="user">
            <input type="hidden" name="user" value="${user}">
            <span class="btnwhite" id="ds" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="document.getElementById('dlform').submit();" help="<@appID />:viewer_download_zip">Download FSI Viewer Zip</span>
   	       </form>
          </td>  
     	 </tr>
     	 
     	 <tr>
     	   <td class="sectionheader" colspan="2">Remove User FSI Viewer</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Delete this users FSI Viewer? All code snips referring to this viewer will be invalid and will no longer work.    
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
   	 	   <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="viewersettings">
            <input type="hidden" name="user" value="${user}">
            <input type="hidden" name="remove_viewer" value="true">
            <@formsubmit value="Remove User FSI Viewer" helpid="viewer_remove_user_copy" />
   	       </form>
          </td>
         </tr>
             
     	<#else>
     	 <tr>
     	   <td class="sectionheader" colspan="2">Create User FSI Viewer</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1" colspan="2">
     	     Create a User FSI Viewer called ${user}?      
     	  </td>
     	 </tr>
     	 <tr>
          <td class="pad1" style="text-align: right;" colspan="2">
     	   <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="viewersettings">
            <input type="hidden" name="user" value="${user}">
            <input type="hidden" name="copy_viewer" value="true">
            <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
            <@formsubmit value="Create User FSI Viewer" helpid="viewer_install_user_copy" />
   	       </form>
          </td>
         </tr>
     	</#if>
     	
     <#else>
     
         <#-- options for the default viewer -->
         <tr>
           <td class="pad1" colspan="2">
             The options below allow managing the default FSI Viewer instance and therefore will apply to all users 
             that do not have a personalized viewer assigned to their account.
           </td>
         </tr>
         <tr>
     	   <td class="sectionheader" colspan="2">Manage Skins</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Upload and delete skins for this FSI Viewer. 
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
           <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="listskins">
            <input type="hidden" name="defaultviewer" value="true">
            <@formsubmit value="Manage Skins" helpid="viewer_manage_skins" />
   	       </form>
          </td>
         </tr>
     
     
         <tr>
     	   <td class="sectionheader" colspan="2">Update Viewer</td>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Upload and install an update for this FSI Viewer. 
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
   	 	   <form action="pt.do" method="post" onsubmit="this.submit();">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="updateviewers">
            <input type="hidden" name="preselect_viewer" value="default">
   	        <@formsubmit value="Update Viewer" helpid="viewer_update" />
   	       </form>
          </td>  
     	 </tr>
     
     
         <tr>
     	   <td class="sectionheader" colspan="2">ZIP and download FSI Viewer</th>
     	 </tr>
     	 <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     	 <tr>
     	  <td class="pad1">
     	     Create and download a zip file containing the default viewer.  
     	  </td>
          <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
   	 	   <form action="pt.do" method="post" id="dlform">    
            <@printRequiredParams method="post" />
            <input type="hidden" name="action" value="zipviewerdir">
            <span class="btnwhite" id="ds" onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="document.getElementById('dlform').submit();" help="<@appID />:viewer_download_zip" >Download FSI Viewer Zip</span>
   	       </form>
          </td>  
     	 </tr>
     
         
     </#if>
     
     </table>
     
   <#elseif request_remove_confirmation?? >
   
     <script type="text/javascript">
      function toggle_ok() {
      	var cb = document.getElementById("confirmbutton");
      	if (cb.className == "btnwhite") {
      	  cb.className = "btnwhitedis"
      	} else {
      	  cb.className = "btnwhite"
      	}
      }
     </script>
     
	 <form action="pt.do" method="post" onsubmit="this.submit();">    
      <@printRequiredParams method="post" />
      <input type="hidden" name="action" value="viewersettings">
      <input type="hidden" name="user" value="${user}">
      <input type="hidden" name="remove_viewer" value="true">
     <table cellspacing="0" cellpadding="0" border="0" width="500px">
     <tr>
      <td class="sectionheader" colspan="2">Remove User FSI Viewer?</td>
     </tr>
     <tr><td colspan="2"><hr size="1" class="hr1"/></td></tr>
     <tr>
      <td class="pad1" colspan="2">
        Removing the users FSI Viewer will also remove any custom skins and/or config 
        files installed for this user.<br />
        <font color="red">This will break all code snips the might have been published 
        using this viewer.</font><br /> 
      </td>
     </tr>
     <tr>
      <td class="pad1">
        Yes, really remove the users FSI Viewer?
      </td>
      <td class="pad1" style="min-width: 0px; padding-top: 10px;" align="right">
          <@formcheckbox objid="confirmed" preselect="false" disabled="false" callbackonchange="toggle_ok" helpid="" />
      </td>
     </tr>
     <tr>
      <td style="text-align: left; padding-top: 30px;" colspan="2"><hr size="1" class="hr1"/></td>
     </tr>
     <tr>
       <td class="pad1" style="min-width: 0px; padding-top: 10px;" colspan="2" align="right">
          <span class=btnwhite onmouseover="spanhover(this);" onmousedown="spandown(this);" onmouseup="spanup(this);" onmouseout="spanup(this);" onclick="history.back();">Cancel</span>
          <@formsubmit id="confirmbutton" disabled="true" value="Ok" />
   	  </td>
   	 </tr> 
     </table>
   	 </form>
    
   </#if>
<@tableFooter/>
<#include "/framework/end_box.ftl">
<#include "/framework/modal_dialogs.ftl">
<#include "/framework/html_footer.ftl">